
clear all
clc
close all

% Execute the original code
run HMmain;
save('EqmResults','Results','pi','p','N','s','r','DaysPerMonth');
clear all;
load('EqmResults');

% User defined
years = 2; % # of years of simulation
NSim = 1000; % # of sample paths
state_init = 3; % initial state
% model = 3; % 1 = MP-Nash, 2 = MP-BRW, 3 = MP-HagMan
Nworkers = 6000; %Size of sample of workers

% Parameters
%T = round(12*years*DaysPerMonth); %Number of periods (days) in the simulation
T=5000
lambda=s%daily job destruction rate
tic;


% Description of saved results:
% The matrix Results contains the equilibrium values of the endogenous
% variables in Hall and Milgrom, as well as some parameters
% Rows 1 - 5: MP - Nash
% Rows 6 - 10: MP - BRW
% Rows 11 - 15: MP - HagMan
% Columns   1: u
%           2: f
%           3: U
%           4: V
%           5: W
%           6: W' (only in MP-BRW, others, just W)
%           7: P
%           8: thetast

% Row 16: Parameters: [beta_nash beta c delta gamma z 0 0]

z_grid = [0.71 0.71 0.932];
cumul_pi = cumsum(pi,2);



% Matrices to store results
Store_state = zeros(T,NSim);
for model = 1:3
    ss = ['Store_expost_loss_' int2str(model) '= zeros(Nworkers,NSim);'];
    eval(ss)
end

% The actual simulations
for nn=1:NSim
    tic;
    % Generate AGGREGATE sample productivity paths
    
    innov_productivity = rand(T,1);
    innov_productivity = innov_productivity*ones(1,N);
    sample_state = zeros(T,1);
    sample_state(1,1) = state_init;
    
    for t = 2:T
        state_today = sample_state(t-1,1);
        check = innov_productivity(t,:) > cumul_pi(state_today,:);
        sample_state(t,1) = sum(check) + 1;
    end
    
    
    for model = 1:1
        
        % Name of the model
        if model == 1
            model_name = 'MP-Nash, Standard';
        elseif model == 2
            model_name = 'MP-BRW';
        elseif model == 3
            model_name = 'MP-Nash, HagMan';
        end
        
        % Generate sample path of job finding probabilities
        f = Results((model-1)*N+1:model*N,2); % from the model choice
        sample_f = f(sample_state);
        
        % Generate sample paths for workers' states (assume all workers in the
        % sample become unemployed in period zero, so they start searching in period 1)
        innov_workers = rand(T,Nworkers); %time goes in rows
        workers_state = zeros(T,Nworkers);
        first_state=[zeros(1,Nworkers-1000) ones(1,1000)];
        workers_state(1,:) = first_state;
        
        for t = 2:T
            % The job finding part
            find(t,:) = innov_workers(t-1,:) <= sample_f(t-1); %Assigns 1 if worker finds a job
            
            % The job destruction part
            loss(t,:) = innov_workers(t-1,:) <= s; %Assigns 1 if job is destructed
            
            % New state
            workers_state(t,:) = workers_state(t-1,:).*(1-loss(t,:)) + (1-workers_state(t-1,:)).*find(t,:);
            % the first term on the RHS updates the state for the employed
            % the second term on the RHS updates the state for the unemployed
            findtake(t,:)=(1-workers_state(t-1,:)).*find(t,:);
            %jobs found by an unemployed
        end
        
        
        % Calculating the employment period flows
        % Under the assumption that period wage is constant if state does not
        % change
        
        g = (1-s)/(1+r); %discount factor
        W = Results((model-1)*N+1:model*N,5); % from the choice model
        w = (eye(N)-g*pi)*W;
        z = z_grid(model);
        U = Results((model-1)*N+1:model*N,3);
        V = Results((model-1)*N+1:model*N,4);
        
        % Assigning corresponding flows
        sample_w = w(sample_state); % a string of paid wages
        sample_flows = workers_state.*(sample_w*ones(1,Nworkers)) + (1-workers_state)*0; % either wage or z
        
        %Computing daily job finding probabilities, then convert to monthly
        %and take sample mean
        sample_f=(findtake*ones(Nworkers,1))./((1-workers_state)*ones(Nworkers,1));%nr of finders rel to nr of unemployed
        sumterm=cumprod(((1-sample_f)*ones(1,25))')'*ones(25,1);
        sample_fmonthly=sample_f.*sumterm;
        avg_find=mean(sample_fmonthly);
        
        %Compute unemployment rates
        sample_u=lambda./(lambda+sample_f);
        avg_u=mean(sample_u);
        
        % Bringing to present value
        discount = ones(T,1)*1/(1+r);
        discount_matrix = (1+r)*cumprod(discount)*ones(1,Nworkers); % matrix of discount factors
        PDV_flows =  discount_matrix(1:T-1,:).*sample_flows(1:T-1,:);
        PDV_flows = sum(PDV_flows);
        %last_asset_value = workers_state(T,:)*(W(sample_state(T))+V(sample_state(T))) + (1-workers_state(T,:))*(U(sample_state(T)));
        PDV_total = PDV_flows ;%+ (1+r)^(-T)*last_asset_value; %adding asset value at the end
        expost_loss =  100*(W(state_init)+V(state_init) - PDV_total)/(W(state_init)+V(state_init));
        
        % Store for later use
        string_store = ['Store_expost_loss_' int2str(model) '(:,nn) = expost_loss;'];
        eval(string_store);
        
        string_store_pdv = ['Store_PDV_' int2str(model) '(:,nn) = PDV_total;'];
        eval(string_store_pdv);
        
        
        store_rates=['Store_rates' int2str(model) '(nn,:)=[avg_find avg_u];'];
        eval(store_rates);
        
    end %for model
    
    display(nn);
    
    % Store for future reference
    Store_state(:,nn) = sample_state;
    toc;
end %for nn

toc;
display(sprintf('%g minutes' ,toc/60))

for model = 1:1
    
    if model == 1
        model_name = 'mp';
    elseif model == 2
        model_name = 'mpcb';
    elseif model == 3
        model_name = 'mphm';
    end
    
    string_matrix = ['Store_expost_loss = Store_expost_loss_' int2str(model) ';'];
    eval(string_matrix);
    string_matrix_pdv=['Store_pdv=Store_PDV_' int2str(model) ';']
    eval(string_matrix_pdv);
    get_rates=['rates = Store_rates' int2str(model) ';']
    eval(get_rates)
    
    
    % the next block creates the subsamples
    frate=rates(:,1);
    frate1=rates(:,1);
    urate=rates(:,2);
    urate1=rates(:,2);
    expost_losses=-100*((Store_pdv(1:5000,:))./(ones(5000,1)*(mean(Store_pdv(5001:6000,:))))-1);
    mean_loss=mean(expost_losses)
    sample1=expost_losses; % thats the full sample
    boom=[prctile(mean_loss,10-1000/NSim) prctile(mean_loss, 10+1100/NSim)];
    bust=[prctile(mean_loss,90-1000/NSim) prctile(mean_loss, 90+1100/NSim)];
    worst=[prctile(mean_loss,100-2100/NSim) prctile(mean_loss, 100)];
    checkboom= mean_loss>boom(1) & mean_loss<=boom(2);
    checkbust= mean_loss>bust(1) & mean_loss<=bust(2);
    checkworst=mean_loss>worst(1)& mean_loss<=worst(2);
    sum([checkboom' checkbust' checkworst'])
    sample2=[];
    frate2=[];
    urate2=[];
    sample3=[];
    frate3=[];
    urate3=[];
    sample4=[];
    frate4=[];
    urate4=[];
    
    
    for l=1:nn
        if checkboom(l)==1;
            sample2=[sample2 expost_losses(:,l)];% the boom sample
            frate2=[frate2 frate(l,:)];
            urate2=[urate2 urate(l,:)];
        end
        if checkbust(l)==1;
            sample3=[sample3 expost_losses(:,l)];% the bust sample
            frate3=[frate3 frate(l,:)];
            urate3=[urate3 urate(l,:)];
        end
        if checkworst(l)==1;
            sample4=[sample4 expost_losses(:,l)];%the worstsample
            frate4=[frate4 frate(l,:)];
            urate4=[urate4 urate(l,:)];
        end
    end
    %%   compute statistics and plots for the different subsamples
    for s=1:4
        % pick sample s
        sample_pick=['sample = sample' int2str(s) ';'];
        eval(sample_pick);
        frate_pick=['frate = frate' int2str(s) ';'];
        eval(frate_pick)
        urate_pick=['urate = urate' int2str(s) ';'];
        eval(urate_pick)
        if s == 1
            sample_name = 'all';
        elseif s == 2
            sample_name = 'boom';
        elseif s == 3
            sample_name = 'bust';
        elseif s == 4
            sample_name= 'worst';
        end
        
        %compute the statistics
        samplevec=reshape(sample,(Nworkers-1000)*Rank(sample),1);
        avg_loss = mean(samplevec);
        std_loss = std(samplevec);
        perc_loss=prctile(samplevec,[10,50,90,99]);
        sample_frate=mean(frate);
        frate_std=std(frate)
        sample_urate=mean(urate);
        urate_std=std(urate);
        nstats=10;
        stats((s-1)*nstats+1:s*nstats,model)=[avg_loss; std_loss; perc_loss' ; sample_frate; frate_std; sample_urate; urate_std];
       
    end
end



